/*
Copyright (c) 2013, Silas Parker
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this
    list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
    The name of Silas Parker may not be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef ETS2_DASHBOARD_PLUGIN_SERIAL_HPP
#define ETS2_DASHBOARD_PLUGIN_SERIAL_HPP

#include <string>

#define WINVER 0x0500
#define _WIN32_WINNT 0x0500
#include <windows.h>

#include <scssdk.h>

class Serial
{
  public:
    Serial();
    ~Serial();
    
    bool is_valid() const;
    bool open(const std::string& name, std::string& errmsg);
    void close();
    
    struct formatted_data
    {
      scs_u8_t speed;
      scs_u8_t rpm;
      bool left_ind;
      bool right_ind;
      bool parking_break;
      bool fuel_warning;
      std::string text;
      
      bool operator==(const formatted_data& o) const
      {
        return (speed == o.speed) && (rpm == o.rpm) &&
          (left_ind == o.left_ind) && (right_ind == o.right_ind) &&
          (text == o.text);
      }
    };
    
    void write(const formatted_data& data);
    void write_default();
    
  private:
    HANDLE com_port;
    formatted_data prev_data;
};

#endif
